# -*- coding: utf-8 -*-

from __future__ import absolute_import

__author__ = "Lululla"
__email__ = "ekekaz@gmail.com"
__copyright__ = "Copyright (c) 2024 Lululla"
__license__ = "GPL-v2"
__version__ = "1.0.0"

import os
import gettext

from Components.Language import language
from Tools.Directories import resolveFilename, SCOPE_PLUGINS

PluginLanguageDomain = "Aglare"
PluginLanguagePath = "Extensions/Aglare/locale"

isDreambox = os.path.exists("/usr/bin/apt-get")


def localeInit():
	if isDreambox:
		lang = language.getLanguage()[:2]
		os.environ["LANGUAGE"] = lang
	if PluginLanguageDomain and PluginLanguagePath:
		gettext.bindtextdomain(PluginLanguageDomain, resolveFilename(SCOPE_PLUGINS, PluginLanguagePath))


if isDreambox:
	def _(txt):
		return gettext.dgettext(PluginLanguageDomain, txt) if txt else ""
else:
	def _(txt):
		translated = gettext.dgettext(PluginLanguageDomain, txt)
		if translated:
			return translated
		else:
			print("[%s] fallback to default translation for %s" % (PluginLanguageDomain, txt))
			return gettext.gettext(txt)

localeInit()
language.addCallback(localeInit)
